// src/admin/seeder/admin-seeder.service.ts
import { Injectable, Logger } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Admin } from '../entity/admin.entity';
import { Repository } from 'typeorm';
import * as bcrypt from 'bcrypt';

@Injectable()
export class AdminSeederService {
  constructor(
    @InjectRepository(Admin)
    private readonly adminRepository: Repository<Admin>,
  ) {}

  async seed() {
    const defaultAdmins = [
      {
        name: 'Super Admin',
        email: 'superadmin@example.com',
        password: '123456',
        image: '',
        status: 1,
      },
      {
        name: 'Admin User',
        email: 'admin@example.com',
        password: '123456',
        image: '',
        status: 1,
      },
    ];

    for (const adminData of defaultAdmins) {
      const exists = await this.adminRepository.findOne({
        where: { email: adminData.email },
      });

      if (exists) {
        // Update existing admin
        exists.name = adminData.name;
        exists.password = await this.hashPassword(adminData.password);
        exists.image = adminData.image;
        exists.status = adminData.status;
        exists.updated_at = new Date().toISOString().split('T')[0];

        await this.adminRepository.save(exists);
        Logger.log(
          `ℹ️ Updated admin: ${adminData.email}`,
          'AdminSeederService',
        );
      } else {
        // Create new admin
        const admin = this.adminRepository.create({
          ...adminData,
          password: await this.hashPassword(adminData.password),
        });

        await this.adminRepository.save(admin);
        Logger.log(
          `✅ Seeded new admin: ${adminData.email}`,
          'AdminSeederService',
        );
      }
    }
  }

  private async hashPassword(password: string): Promise<string> {
    const salt = await bcrypt.genSalt(10);
    return bcrypt.hash(password, salt);
  }
}
