import { BlogCategory } from 'src/blog_category/entity/blog_category.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  BeforeInsert,
  BeforeUpdate,
  JoinColumn,
} from 'typeorm';

@Entity('blogs')
export class Blog {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'varchar' })
  title: string;

  @Column({ type: 'longtext' })
  content: string;

  @Column({ type: 'varchar', unique: true })
  slug: string;

  @Column({ type: 'varchar', nullable: true })
  image: string;

  @Column({ type: 'varchar', nullable: true })
  alter_image: string;

  @Column({ type: 'tinyint', default: 1 })
  status: number;

  @Column({ type: 'date', nullable: true })
  created_at: string;

  @Column({ type: 'date', nullable: true })
  updated_at: string;

  @Column({ nullable: true })
  created_by: number;

  @Column({ nullable: true })
  updated_by: number;

  @Column({ nullable: true })
  category_id: number | null;

  // ✅ Optional relationship with category
  @ManyToOne(() => BlogCategory, (category) => category.blogs, {
    nullable: true,
    onDelete: 'SET NULL',
  })
  @JoinColumn({ name: 'category_id' })
  category: BlogCategory | null;

  @BeforeInsert()
  setCreatedAt() {
    this.created_at = new Date().toISOString().split('T')[0];
  }

  @BeforeUpdate()
  setUpdatedAt() {
    this.updated_at = new Date().toISOString().split('T')[0];
  }
}
