import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Blog } from './blog.entity';
import { BlogService } from './blog.service';
import { BlogController } from './blog.controller';
import { BlogCategory } from 'src/blog_category/entity/blog_category.entity';
import { BlogCategoryModule } from 'src/blog_category/blog_category.module';

@Module({
    imports: [TypeOrmModule.forFeature([Blog, BlogCategory]), BlogCategoryModule],
    providers: [BlogService],
    controllers: [BlogController],
})
export class BlogModule { }
