import { Blog } from 'src/blog/blog.entity';
import { Entity, PrimaryGeneratedColumn, Column, OneToMany } from 'typeorm';

@Entity('blog_categories')
export class BlogCategory {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'varchar', unique: true })
  name: string;

  @Column({ type: 'tinyint', default: 1 })
  status: number; // 1 = Active, 0 = Inactive

  @OneToMany(() => Blog, (blog) => blog.category)
  blogs: Blog[];
}
