import { Injectable } from '@nestjs/common';
import { MailService } from 'src/mail/mail.service';
import { CreateContactUsDto } from './dtos/create-contact-us.dto';

@Injectable()
export class ContactUsService {
  constructor(private readonly mailService: MailService) {}

  async submitContactForm(dto: CreateContactUsDto) {
    const { name, email, subject, message } = dto;

    // Call the reusable MailService helper
    const result = await this.mailService.sendContactUs({
      name,
      email,
      subject,
      message,
    });

    if (result.success) {
      return { success: true, message: 'Contact form submitted. Email sent.' };
    }

    return { success: false, message: 'Failed to send contact email.', error: result.error };
  }
}
