import 'reflect-metadata';
import { DataSource } from 'typeorm'; // adjust path
import * as dotenv from 'dotenv';
import { Admin } from './admin/entity/admin.entity';

dotenv.config(); // load environment variables if any

export const AppDataSource = new DataSource({
  type: 'mysql', // or your database type
  host: process.env.DB_HOST || 'localhost',
  port: Number(process.env.DB_PORT) || 3306,
  username: process.env.DB_USERNAME || 'root',
  password: process.env.DB_PASSWORD || 'password',
  database: process.env.DB_NAME || 'mydb',
  entities: [Admin], // add other entities if needed
  synchronize: false, // set false for production
  logging: true,
});
