import {
    Controller,
    Post,
    Get,
    Put,
    Param,
    Body,
    UseInterceptors,
    UploadedFiles,
    Delete,
    UploadedFile,
} from '@nestjs/common';
import { FileInterceptor, FilesInterceptor } from '@nestjs/platform-express';
import { multerConfig } from 'src/common/utils/multer.config';
import { GalleryService } from './gallery.service';

@Controller('galleries')
export class GalleryController {
    constructor(private readonly galleryService: GalleryService) { }

    @Post('create')
    @UseInterceptors(FileInterceptor('image', multerConfig('uploads/galleries')))
    async create(@UploadedFile() file: Express.Multer.File, @Body() dto: any) {
        return this.galleryService.create(dto, file);
    }

    @Get('list')
    async findAll() {
        return await this.galleryService.findAll();
    }

    @Get('findBy/:id')
    async findById(@Param('id') id: number) {
        return await this.galleryService.findById(id);
    }

    @Put('update/:id')
    @UseInterceptors(FileInterceptor('image', multerConfig('uploads/galleries')))
    async update(
        @Param('id') id: number,
        @UploadedFile() file: Express.Multer.File,
        @Body() dto: any,
    ) {
        return this.galleryService.update(id, dto, file);
    }

    @Put('toggleStatus/:id')
    async toggleStatus(@Param('id') id: number) {
        return await this.galleryService.toggleStatus(id);
    }

    @Delete('softDelete/:id')
    async softDelete(@Param('id') id: number) {
        return await this.galleryService.softDelete(id);
    }
}
