import { Entity, PrimaryGeneratedColumn, Column, BeforeInsert, BeforeUpdate } from 'typeorm';

@Entity('galleries')
export class Gallery {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'text', nullable: true })
  title: string;

  // store image filenames as JSON array
  @Column({ type: 'text', nullable: true })
  images: string;

  @Column({ type: 'int', default: 1 }) // 1 = active, 0 = inactive, 2 = soft deleted
  status: number;

  @Column({ type: 'text', nullable: true })
  alt_image: string;

  @Column({ type: 'text', nullable: true })
  Image_path: string;

  @Column({ type: 'date', nullable: true })
  created_at: string;

  @Column({ type: 'date', nullable: true })
  updated_at: string;

  @BeforeInsert()
  setCreatedDate() {
    const today = new Date().toISOString().slice(0, 10);
    this.created_at = today;
  }

  @BeforeUpdate()
  setUpdatedDate() {
    this.updated_at = new Date().toISOString().slice(0, 10);
  }
}
