import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, JoinColumn, BeforeInsert, BeforeUpdate } from 'typeorm';
import { Program } from 'src/program/program.entity';

@Entity('program_details')
export class ProgramDetail {
    @PrimaryGeneratedColumn()
    id: number;

    @ManyToOne(() => Program, (program) => program.program_details, { nullable: false })
    @JoinColumn({ name: 'program_id' })
    program: Program;

    @Column({ nullable: true })
    program_id: number;

    @Column({ nullable: true })
    title: string;

    @Column({ type: 'text'})
    description: string;

    @Column({ nullable: true })
    image: string;

    @Column({ nullable: true })
    alter_image: string;

    @Column({ nullable: true })
    image_name: string;

    @Column({ type: 'tinyint', default: 1 })
    status: number;

    @Column({ nullable: true })
    created_by: number;

    @Column({ nullable: true })
    updated_by: number;

    @Column({ type: 'date', nullable: true })
    created_at: string;

    @Column({ type: 'date', nullable: true })
    updated_at: string;

    @BeforeInsert()
    setCreateDateParts() {
        const today = new Date();
        this.created_at = today.toISOString().split('T')[0];
    }

    @BeforeUpdate()
    setUpdateDate() {
        const today = new Date();
        this.updated_at = today.toISOString().split('T')[0];
    }
}
