import { ProgramDetail } from 'src/program-detail/program-detail.entity';
import { Transaction } from 'src/transaction/transaction.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  BeforeInsert,
  BeforeUpdate,
  OneToMany,
} from 'typeorm';

@Entity('programs')
export class Program {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ nullable: true })
  heading: string;

  @Column({ nullable: true })
  title: string;

  @Column({ type: 'text' })
  description: string;

  @Column({ type: 'text', nullable: true })
  image: string;

  // // SEO Fields
  // @Column({ nullable: true })
  // slug: string;

  // @Column({ type: 'varchar', length: 1000 , nullable: true })
  // meta_title: string;

  // @Column({ type: 'varchar', length: 1000 })
  // meta_description: string;

  //   @Column({ nullable: true, type: 'json' })
  //   schema_json: Record<string, any>;


  // @Column({ nullable: true })
  // canonical_url: string;

  // @Column({ nullable: true })
  // keyword: string;

  // 1 = active , 0 = inactive
  @Column({ default: 1 })
  status: number;

  @Column({ nullable: true })
  date: string;

  @Column({ nullable: true })
  location: string;

  @Column({ nullable: true })
  campain_status: string;

  @Column({ nullable: true })
  required_total_amount: string;

  @Column({ nullable: true })
  created_by: number;

  @Column({ nullable: true })
  updated_by: number;

  @Column({ type: 'date', nullable: true })
  created_at: string;

  @Column({ type: 'date', nullable: true })
  updated_at: string;

  @OneToMany(() => ProgramDetail, (detail) => detail.program)
  program_details: ProgramDetail[];

  @OneToMany(() => Transaction, (transaction) => transaction.program)
  transactions: Transaction[];

  @BeforeInsert()
  setCreateDate() {
    const today = new Date().toISOString().split('T')[0];
    this.created_at = today;
  }

  @BeforeUpdate()
  setUpdateDate() {
    const today = new Date().toISOString().split('T')[0];
    this.updated_at = today;
  }
}
