import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Program } from './program.entity';
import { ProgramService } from './program.service';
import { ProgramController } from './program.controller';
import { ProgramDetail } from 'src/program-detail/program-detail.entity';
import { pageHeadings } from 'src/service/page-heading.entity';

@Module({
    imports: [TypeOrmModule.forFeature([pageHeadings, Program, ProgramDetail])],
    controllers: [ProgramController],
    providers: [ProgramService],
})
export class ProgramModule { }
