import { Controller, Get, Param, Delete, Patch, Query, Put } from '@nestjs/common';
import { ServiceDetailImageService } from './service-detail-image.service';

@Controller('service-detail-images')
export class ServiceDetailImageController {
    constructor(private readonly imageService: ServiceDetailImageService) { }

    // 📜 List all images (optionally by detail ID)
    @Get('list')
    async findAll(@Query('detail_id') detailId?: number) {
        return await this.imageService.findAll(detailId);
    }

    // 🔁 Toggle status (active/inactive)
    @Put('toggleStatus/:id')
    async toggleStatus(@Param('id') id: number) {
        return await this.imageService.toggleStatus(id);
    }

    // ❌ Delete image (from DB + server)
    @Delete('delete/:id')
    async deleteImage(@Param('id') id: number) {
        return await this.imageService.deleteImage(id);
    }
}
