// src/service-detail-image/service-detail-image.entity.ts
import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, JoinColumn, BeforeInsert } from 'typeorm';
import { ServiceDetail } from 'src/service-detail/service-detail.entity';

@Entity('service_detail_images')
export class ServiceDetailImage {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  image_path: string;

  @Column({ type: 'tinyint', default: 1 }) // 1 = active, 0 = inactive
  status: number;

  @ManyToOne(() => ServiceDetail, (detail) => detail.images, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'service_detail_id' })
  detail: ServiceDetail;

  @Column()
  service_detail_id: number;

  @Column({ type: 'date' })
  created_at: string;

  @BeforeInsert()
  setDates() {
    const today = new Date().toISOString().split('T')[0];
    this.created_at = today;
  }
}
