import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, JoinColumn, BeforeInsert } from 'typeorm';
import { ServiceDetail } from 'src/service-detail/service-detail.entity';

@Entity()
export class ServiceBullet {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({nullable: true, type: 'text'})
    text: string;

    @Column({ type: 'tinyint', default: 1 })
    status: number; // 0 = inactive, 1 = active

    @ManyToOne(() => ServiceDetail, detail => detail.bullets, { onDelete: 'CASCADE' })
    @JoinColumn({ name: 'service_detail_id' })
    service_detail: ServiceDetail;

    @Column()
    service_detail_id: number;

    @Column({nullable: true, type: 'text'})
    icon: string;

    @Column({nullable: true, type: 'text'})
    alt_icon: string;

    @Column({nullable: true, type: 'text'})
    title: string;

    @BeforeInsert()
    setDefaultStatus() {
        if (this.status === undefined) this.status = 1;
    }
}
