import { Controller, Get, Post, Put, Param, Body, Delete, UseInterceptors, UploadedFile, UseGuards, Req } from '@nestjs/common';
import { ServiceDetailService } from './service-detail.service';
import { CreateServiceDetailDto } from './dto/create-service-detail.dto';
import { UpdateServiceDetailDto } from './dto/update-service-detail.dto';
import { FileInterceptor } from '@nestjs/platform-express';
import { multerConfig } from 'src/common/utils/multer.config';
import { AdminJwtAuthGuard } from 'src/auth/admin/admin-jwt.guard';

@Controller('service-details')
export class ServiceDetailController {
    constructor(private readonly serviceDetailService: ServiceDetailService) {}

    @Post('create')
    @UseGuards(AdminJwtAuthGuard)
    @UseInterceptors(FileInterceptor('image', multerConfig('uploads')))
    async create(@Body() dto: CreateServiceDetailDto, @UploadedFile() file: Express.Multer.File, @Req() req: any) {
        if (file) {
            dto.image = file.path;
            dto.image_name = file.originalname;
        }
        const admin = req.user as any;
        const createdBy = admin?.id;
        return this.serviceDetailService.create(dto, createdBy);
    }

    @Get('list')
    findAll() {
        return this.serviceDetailService.findAll();
    }

    @Get('findby/:id')
    findOne(@Param('id') id: number) {
        return this.serviceDetailService.findOne(id);
    }

    @Put('update/:id')
    @UseGuards(AdminJwtAuthGuard)
    @UseInterceptors(FileInterceptor('image', multerConfig('uploads')))
    update(@Param('id') id: number, @Body() dto: UpdateServiceDetailDto, @UploadedFile() file: Express.Multer.File, @Req() req: any) {
        if (file) {
            dto.image = file.path;
            dto.image_name = file.originalname;
        }
        const admin = req.user as any;
        const updatedBy = admin?.id;
        return this.serviceDetailService.update(id, dto, updatedBy);
    }

    @Put('toggle-status/:id')
    @UseGuards(AdminJwtAuthGuard)
    toggleStatus(@Param('id') id: number) {
        return this.serviceDetailService.toggleStatus(id);
    }
}
