import { IsString, IsOptional, IsArray, ValidateNested, IsNumber, IsNotEmpty } from 'class-validator';
import { Type } from 'class-transformer';

class ServiceDetailImageDto {
    @IsOptional()
    @IsString()
    image_path?: string;

}

class ServiceBulletDto {
    @IsString()
    text: string;

    @IsOptional()
    @IsString()
    title?: string;

    @IsOptional()
    @IsString()
    alt_icon?: string;

}


class ServiceDetailDto {

    @IsOptional()
    @IsString()
    heading?: string;

    @IsString()
    title: string;

    @IsString()
    description: string;

    @IsOptional()
    @IsString()
    type?: string;

    @IsOptional()
    @IsString()
    button_text?: string;

    @IsOptional()
    @IsString()
    button_Url?: string;

    @IsOptional()
    @IsArray()
    @ValidateNested({ each: true })
    @Type(() => ServiceDetailImageDto)
    images?: ServiceDetailImageDto[];

    @IsOptional()
    @IsArray()
    @ValidateNested({ each: true })
    @Type(() => ServiceBulletDto)
    bullets?: ServiceBulletDto[];

}

export class CreateServiceDto {
    @IsString()
    heading: string;

    @IsOptional()
    @IsString()
    title?: string;

    @IsString()
    description: string;
    
    @IsOptional()
    @IsString()
    banner_heading?: string;

    @IsString()
    banner_description: string;

    @IsString()
    @IsNotEmpty()
    slug: string;

    @IsOptional()
    @IsString()
    meta_title?: string;

    @IsOptional()
    @IsString()
    meta_description?: string;

    @IsOptional()
    schema_json?: Record<string, any>;

    @IsOptional()
    @IsString()
    canonical_url?: string;

    @IsOptional()
    @IsString()
    keyword?: string;

    @IsOptional()
    @IsNumber()
    created_by?: number;

    @IsArray()
    @ValidateNested({ each: true })
    @Type(() => ServiceDetailDto)
    details: ServiceDetailDto[];

    @IsArray()
    @IsString({ each: true })
    imageGroups: string[];
}
