import { emit } from 'process';
import { ServiceDetail } from 'src/service-detail/service-detail.entity';
import { Entity, PrimaryGeneratedColumn, Column, BeforeInsert, BeforeUpdate, OneToMany } from 'typeorm';

export enum PageType {
    SERVICE = 'SERVICE',
    PROGRAM = 'PROGRAMS',
}

@Entity('page_heading')
export class pageHeadings {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ nullable: true })
    heading: string;

    @Column({ nullable: false })
    title: string;

    @Column({ type: 'enum', enum: PageType, default: PageType.SERVICE, })
    type: PageType;

    @Column({ type: 'text' })
    description: string;

    @Column({ type: 'date', nullable: true })
    created_at: string;

    @Column({ type: 'date', nullable: true })
    updated_at: string;

    @BeforeInsert()
    setCreateDateParts() {
        const today = new Date();
        const onlyDate = today.toISOString().split('T')[0];
        this.created_at = onlyDate;
    }

    @BeforeUpdate()
    setUpdateDate() {
        const today = new Date();
        const onlyDate = today.toISOString().split('T')[0];
        this.updated_at = onlyDate;
    }
}
