import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Service } from './service.entity';
import { ServiceService } from './service.service';
import { ServiceController } from './service.controller';
import { ServiceDetail } from 'src/service-detail/service-detail.entity';
import { ServiceDetailImage } from 'src/service-detail-image/service-detail-image.entity';
import { ServiceBullet } from 'src/service-detail-point/service-detail-point.entity';
import { pageHeadings } from './page-heading.entity';

@Module({
  imports: [TypeOrmModule.forFeature([pageHeadings, Service, ServiceDetail, ServiceDetailImage, ServiceBullet])],
  controllers: [ServiceController],
  providers: [ServiceService],
})
export class ServiceModule { }
