// src/settings/dto/update-setting.dto.ts
import { IsOptional, IsString, Matches } from 'class-validator';

export class UpdateSettingDto {
  @IsOptional()
  @IsString()
  fb_link?: string;

  @IsOptional()
  @IsString()
  instagram_link?: string;

  @IsOptional()
  @IsString()
  twitter_link?: string;

  @IsOptional()
  @IsString()
  whatsapp_link?: string;

  @IsOptional()
  @IsString()
  address?: string;

  @IsOptional()
  @Matches(/^\+?\d{10,15}$/, { message: 'Phone number must be 10-15 digits, optional +' })
  phone?: string;

  @IsOptional()
  @IsString()
  email?: string;
}