// src/settings/seeder/settings-seeder.service.ts
import { Injectable, Logger } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Setting } from '../settings.entity';

@Injectable()
export class SettingsSeederService {
  private readonly logger = new Logger(SettingsSeederService.name);

  constructor(
    @InjectRepository(Setting)
    private readonly settingRepo: Repository<Setting>,
  ) {}

  async seed() {
    const exists = await this.settingRepo.findOneBy({});
    if (exists) {
      this.logger.log('Settings already seeded');
      return;
    }

    const defaultSettings = this.settingRepo.create({
      fb_link: '',
      fb_logo: '',
      instagram_link: '',
      instagram_logo: '',
      twitter_link: '',
      twitter_logo: '',
      whatsapp_link: '',
      whatsapp_logo: '',
      website_logo: '',
      address: '',
      phone: '',
      email: '',
    });

    await this.settingRepo.save(defaultSettings);
    this.logger.log('Settings seeded successfully');
  }
}
