// src/settings/settings.controller.ts
import {
    Controller,
    Get,
    Put,
    Body,
    UseInterceptors,
    UploadedFiles,
    UseGuards,
} from '@nestjs/common';
import { SettingsService } from './settings.service';
import { UpdateSettingDto } from './dto/update-setting.dto';
import { FileFieldsInterceptor, FilesInterceptor } from '@nestjs/platform-express';
import { multerConfig } from 'src/common/utils/multer.config';
import { AdminJwtAuthGuard } from 'src/auth/admin/admin-jwt.guard';

@Controller('settings')
export class SettingsController {
    constructor(private readonly settingsService: SettingsService) { }

    @Get('list')
    async getSettings() {
        return this.settingsService.getSettings();
    }

    @Put('update')
    @UseGuards(AdminJwtAuthGuard)
    @UseInterceptors(
        FileFieldsInterceptor(
            [
                { name: 'fb_logo', maxCount: 1 },
                { name: 'instagram_logo', maxCount: 1 },
                { name: 'twitter_logo', maxCount: 1 },
                { name: 'whatsapp_logo', maxCount: 1 },
                { name: 'website_logo', maxCount: 1 },
            ],
            multerConfig('uploads'),
        ),
    )
    async updateSettings(
        @Body() updateDto: UpdateSettingDto,
        @UploadedFiles() files: {
            fb_logo?: Express.Multer.File[];
            instagram_logo?: Express.Multer.File[];
            twitter_logo?: Express.Multer.File[];
            whatsapp_logo?: Express.Multer.File[];
            website_logo?: Express.Multer.File[];
        },
    ) {
        const singleFiles: { [key: string]: Express.Multer.File } = {};
        if (files?.fb_logo?.[0]) singleFiles.fb_logo = files.fb_logo[0];
        if (files?.instagram_logo?.[0]) singleFiles.instagram_logo = files.instagram_logo[0];
        if (files?.twitter_logo?.[0]) singleFiles.twitter_logo = files.twitter_logo[0];
        if (files?.whatsapp_logo?.[0]) singleFiles.whatsapp_logo = files.whatsapp_logo[0];
        if (files?.website_logo?.[0]) singleFiles.website_logo = files.website_logo[0];

        return this.settingsService.updateSettings(updateDto, singleFiles);
    }

}
