// src/transaction/dto/create-transaction.dto.ts
import { IsString, IsOptional, IsNumber, IsNotEmpty, MinLength, IsEmail, Matches } from 'class-validator';

export class CreateTransactionDto {
  @IsOptional()
  @IsString()
  transaction_id?: string;

  @IsString()
  status: string;

  @IsNumber()
  amount: number;

  @IsString()
  currency_code: string;

  @IsString()
  payment_through: string;

  @IsNotEmpty()
  @IsNumber()
  category_id?: number;

  @IsNotEmpty()
  @IsString()
  @MinLength(3, { message: 'Name must be at least 3 characters long' })
  name: string;

  @IsNotEmpty()
  @IsEmail({}, { message: 'Invalid email format' })
  @Matches(
    /^[^\s@]+@[^\s@]+\.[a-zA-Z]{2,}$/,
    { message: 'Email must be a valid format (e.g., user@example.com)' }
  )
  email: string;

  @IsNotEmpty()
  @IsString()
  @MinLength(5, { message: 'Address must be at least 5 characters long' })
  address: string;

  @IsNotEmpty()
  @Matches(/^[0-9]{10,15}$/, { message: 'Telephone must contain 10–15 digits only' })
  telephone: string;

  @IsOptional()
  @IsNumber()
  support_program?: number;

  @IsOptional()
  @IsNumber()
  support_service?: number;
}
